% Leggi i dati da Excel
filename='sensore 2'
data = readtable(filename, 'TextType', 'string');


Tensione = data{:, 1};  
Pressione = data{:, 2};


%% 
% Calcolo dei parametri della regressione
p = polyfit(Tensione, Pressione, 1); % Regressione lineare (grado 1)

% Risultati
coeff_angolare = p(1); % Coefficiente angolare (m)
intercetta = p(2); % Intercetta (y0)

disp(['Coefficiente angolare (m): ', num2str(coeff_angolare)]);
disp(['Intercetta (y0): ', num2str(intercetta)]);

% Calcolo della retta di regressione
pressione_fit = polyval(p, Tensione);

% Visualizzazione
figure;
scatter(Tensione, Pressione, 'filled'); % Dati sperimentali
hold on;
plot(Tensione, pressione_fit, '-r', 'LineWidth', 2); % Linea di regressione
grid on;
xlabel('Tensione (V)');
ylabel('Pressione (bar)');
title('Regressione Lineare: Taratura Trasduttore di Pressione');
legend('Dati sperimentali', 'Retta di regressione');
hold off;

save(filename,"Tensione","Pressione","coeff_angolare","intercetta");